/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.HostWrapper;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotProxy;
import com.oracle.truffle.polyglot.PolyglotValueFactory;
import com.oracle.truffle.polyglot.ToHostNode;
import com.oracle.truffle.polyglot.ToHostNodeGen;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

abstract class PolyglotValue
extends AbstractPolyglotImpl.AbstractValueImpl {
    private static final String TRUNCATION_SUFFIX = "...";
    private static final String UNKNOWN = "Unknown";
    protected final PolyglotLanguageContext languageContext;
    static final InteropLibrary UNCACHED_INTEROP = InteropLibrary.getFactory().getUncached();
    private static final int CHARACTER_LIMIT = 140;
    private static final InteropLibrary INTEROP = InteropLibrary.getFactory().getUncached();

    PolyglotValue(PolyglotLanguageContext languageContext) {
        super((AbstractPolyglotImpl)languageContext.getEngine().impl);
        this.languageContext = languageContext;
    }

    PolyglotValue(PolyglotImpl polyglot, PolyglotLanguageContext languageContext) {
        super((AbstractPolyglotImpl)polyglot);
        this.languageContext = languageContext;
    }

    public final Context getContext() {
        if (this.languageContext == null) {
            return null;
        }
        return this.languageContext.context.currentApi;
    }

    public Value getArrayElement(Object receiver, long index) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Value value = PolyglotValue.getArrayElementUnsupported(this.languageContext, receiver);
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Value getArrayElementUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "getArrayElement(long)", "hasArrayElements()");
    }

    public void setArrayElement(Object receiver, long index, Object value) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            PolyglotValue.setArrayElementUnsupported(this.languageContext, receiver);
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static void setArrayElementUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "setArrayElement(long, Object)", "hasArrayElements()");
    }

    public boolean removeArrayElement(Object receiver, long index) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.removeArrayElementUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException removeArrayElementUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "removeArrayElement(long, Object)", null);
    }

    public long getArraySize(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            long l = PolyglotValue.getArraySizeUnsupported(this.languageContext, receiver);
            return l;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static long getArraySizeUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "getArraySize()", "hasArrayElements()");
    }

    public boolean isBufferWritable(Object receiver) throws UnsupportedOperationException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.isBufferWritableUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException isBufferWritableUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "isBufferWritable()", "hasBufferElements()");
    }

    public long getBufferSize(Object receiver) throws UnsupportedOperationException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.getBufferSizeUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException getBufferSizeUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "getBufferSize()", "hasBufferElements()");
    }

    public byte readBufferByte(Object receiver, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.readBufferByteUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException readBufferByteUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "readBufferByte()", "hasBufferElements()");
    }

    public void writeBufferByte(Object receiver, long byteOffset, byte value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.writeBufferByteUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException writeBufferByteUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "writeBufferByte()", "hasBufferElements()");
    }

    public short readBufferShort(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.readBufferShortUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException readBufferShortUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "readBufferShort()", "hasBufferElements()");
    }

    public void writeBufferShort(Object receiver, ByteOrder order, long byteOffset, short value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.writeBufferShortUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException writeBufferShortUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "writeBufferShort()", "hasBufferElements()");
    }

    public int readBufferInt(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.readBufferIntUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException readBufferIntUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "readBufferInt()", "hasBufferElements()");
    }

    public void writeBufferInt(Object receiver, ByteOrder order, long byteOffset, int value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.writeBufferIntUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException writeBufferIntUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "writeBufferInt()", "hasBufferElements()");
    }

    public long readBufferLong(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.readBufferLongUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException readBufferLongUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "readBufferLong()", "hasBufferElements()");
    }

    public void writeBufferLong(Object receiver, ByteOrder order, long byteOffset, long value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.writeBufferLongUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException writeBufferLongUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "writeBufferLong()", "hasBufferElements()");
    }

    public float readBufferFloat(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.readBufferFloatUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException readBufferFloatUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "readBufferFloat()", "hasBufferElements()");
    }

    public void writeBufferFloat(Object receiver, ByteOrder order, long byteOffset, float value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.writeBufferFloatUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException writeBufferFloatUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "writeBufferFloat()", "hasBufferElements()");
    }

    public double readBufferDouble(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.readBufferDoubleUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException readBufferDoubleUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "readBufferDouble()", "hasBufferElements()");
    }

    public void writeBufferDouble(Object receiver, ByteOrder order, long byteOffset, double value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.writeBufferDoubleUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException writeBufferDoubleUnsupported(PolyglotLanguageContext context, Object receiver) {
        return PolyglotValue.unsupported(context, receiver, "writeBufferDouble()", "hasBufferElements()");
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidBufferIndex(PolyglotLanguageContext context, Object receiver, long byteOffset, long size) {
        String message = String.format("Invalid buffer access of length %d at byte offset %d for buffer %s.", size, byteOffset, PolyglotValue.getValueInfo(context, receiver));
        throw PolyglotEngineException.bufferIndexOutOfBounds(message);
    }

    public Value getMember(Object receiver, String key) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Value value = PolyglotValue.getMemberUnsupported(this.languageContext, receiver, key);
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Value getMemberUnsupported(PolyglotLanguageContext context, Object receiver, String key) {
        throw PolyglotValue.unsupported(context, receiver, "getMember(String)", "hasMembers()");
    }

    public void putMember(Object receiver, String key, Object member) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            PolyglotValue.putMemberUnsupported(this.languageContext, receiver);
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException putMemberUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "putMember(String, Object)", "hasMembers()");
    }

    public boolean removeMember(Object receiver, String key) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.removeMemberUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException removeMemberUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "removeMember(String, Object)", null);
    }

    public Value execute(Object receiver, Object[] arguments) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.executeUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    public Value execute(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.executeUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException executeUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "execute(Object...)", "canExecute()");
    }

    public Value newInstance(Object receiver, Object[] arguments) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Value value = PolyglotValue.newInstanceUnsupported(this.languageContext, receiver);
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Value newInstanceUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "newInstance(Object...)", "canInstantiate()");
    }

    public void executeVoid(Object receiver, Object[] arguments) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            PolyglotValue.executeVoidUnsupported(this.languageContext, receiver);
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    public void executeVoid(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            PolyglotValue.executeVoidUnsupported(this.languageContext, receiver);
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static void executeVoidUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "executeVoid(Object...)", "canExecute()");
    }

    public Value invoke(Object receiver, String identifier, Object[] arguments) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.invokeUnsupported(this.languageContext, receiver, identifier);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    public Value invoke(Object receiver, String identifier) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.invokeUnsupported(this.languageContext, receiver, identifier);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invokeUnsupported(PolyglotLanguageContext context, Object receiver, String identifier) {
        throw PolyglotValue.unsupported(context, receiver, "invoke(" + identifier + ", Object...)", "canInvoke(String)");
    }

    public String asString(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            String string = this.asStringUnsupported(receiver);
            return string;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final String asStringUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, String.class, "asString()", "isString()", "Invalid coercion.");
    }

    public boolean asBoolean(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            boolean bl = this.asBooleanUnsupported(receiver);
            return bl;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    private static boolean isNullUncached(Object receiver) {
        return InteropLibrary.getFactory().getUncached().isNull(receiver);
    }

    protected final boolean asBooleanUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Boolean.TYPE, "asBoolean()", "isBoolean()", "Invalid or lossy primitive coercion.");
    }

    private <T> T invalidCastPrimitive(Object receiver, Class<T> clazz, String asMethodName, String isMethodName, String detail) {
        assert (this.languageContext == null || !this.languageContext.context.engine.needsEnter(this.languageContext.context));
        if (PolyglotValue.isNullUncached(receiver)) {
            throw PolyglotValue.nullCoercion(this.languageContext, receiver, clazz, asMethodName, isMethodName);
        }
        throw PolyglotValue.cannotConvert(this.languageContext, receiver, clazz, asMethodName, isMethodName, detail);
    }

    public int asInt(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            int n = this.asIntUnsupported(receiver);
            return n;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final int asIntUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Integer.TYPE, "asInt()", "fitsInInt()", "Invalid or lossy primitive coercion.");
    }

    public long asLong(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            long l = this.asLongUnsupported(receiver);
            return l;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final long asLongUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Long.TYPE, "asLong()", "fitsInLong()", "Invalid or lossy primitive coercion.");
    }

    public double asDouble(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            double d = this.asDoubleUnsupported(receiver);
            return d;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final double asDoubleUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Double.TYPE, "asDouble()", "fitsInDouble()", "Invalid or lossy primitive coercion.");
    }

    public float asFloat(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            float f = this.asFloatUnsupported(receiver);
            return f;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final float asFloatUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Float.TYPE, "asFloat()", "fitsInFloat()", "Invalid or lossy primitive coercion.").floatValue();
    }

    public byte asByte(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            byte by = this.asByteUnsupported(receiver);
            return by;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final byte asByteUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Byte.TYPE, "asByte()", "fitsInByte()", "Invalid or lossy primitive coercion.");
    }

    public short asShort(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            short s = this.asShortUnsupported(receiver);
            return s;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final short asShortUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Short.TYPE, "asShort()", "fitsInShort()", "Invalid or lossy primitive coercion.");
    }

    public long asNativePointer(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            long l = PolyglotValue.asNativePointerUnsupported(this.languageContext, receiver);
            return l;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    static long asNativePointerUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.cannotConvert(context, receiver, Long.TYPE, "asNativePointer()", "isNativeObject()", "Value cannot be converted to a native pointer.");
    }

    public Object asHostObject(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Object object = this.asHostObjectUnsupported(receiver);
            return object;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final Object asHostObjectUnsupported(Object receiver) {
        throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asHostObject()", "isHostObject()", "Value is not a host object.");
    }

    public Object asProxyObject(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Object object = this.asProxyObjectUnsupported(receiver);
            return object;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final Object asProxyObjectUnsupported(Object receiver) {
        throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asProxyObject()", "isProxyObject()", "Value is not a proxy object.");
    }

    public LocalDate asDate(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            if (PolyglotValue.isNullUncached(receiver)) {
                LocalDate localDate = null;
                return localDate;
            }
            try {
                throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asDate()", "isDate()", "Value does not contain date information.");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    public LocalTime asTime(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            if (PolyglotValue.isNullUncached(receiver)) {
                LocalTime localTime = null;
                return localTime;
            }
            try {
                throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asTime()", "isTime()", "Value does not contain time information.");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    public ZoneId asTimeZone(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            if (PolyglotValue.isNullUncached(receiver)) {
                ZoneId zoneId = null;
                return zoneId;
            }
            try {
                throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asTimeZone()", "isTimeZone()", "Value does not contain time zone information.");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    public Instant asInstant(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            if (PolyglotValue.isNullUncached(receiver)) {
                Instant instant = null;
                return instant;
            }
            try {
                throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asInstant()", "isInstant()", "Value does not contain instant information.");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    public Duration asDuration(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            if (PolyglotValue.isNullUncached(receiver)) {
                Duration duration = null;
                return duration;
            }
            try {
                throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asDuration()", "isDuration()", "Value does not contain duration information.");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    public RuntimeException throwException(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.unsupported(this.languageContext, receiver, "throwException()", "isException()");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    public final Value getMetaObject(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Value value = this.getMetaObjectImpl(receiver);
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    public Value getIterator(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Value value = PolyglotValue.getIteratorUnsupported(this.languageContext, receiver);
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final Value getIteratorUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "getIterator()", "hasIterator()");
    }

    public boolean hasIteratorNextElement(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            boolean bl = PolyglotValue.hasIteratorNextElementUnsupported(this.languageContext, receiver);
            return bl;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final boolean hasIteratorNextElementUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "hasIteratorNextElement()", "isIterator()");
    }

    public Value getIteratorNextElement(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Value value = PolyglotValue.getIteratorNextElementUnsupported(this.languageContext, receiver);
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final Value getIteratorNextElementUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "getIteratorNextElement()", "isIterator()");
    }

    public long getHashSize(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.getHashSizeUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException getHashSizeUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "getHashSize()", "hasHashEntries()");
    }

    public Value getHashValue(Object receiver, Object key) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.getHashValueUnsupported(this.languageContext, receiver, key);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException getHashValueUnsupported(PolyglotLanguageContext context, Object receiver, Object key) {
        throw PolyglotValue.unsupported(context, receiver, "getHashValue(Object)", "hasHashEntries()");
    }

    public Value getHashValueOrDefault(Object receiver, Object key, Object defaultValue) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.getHashValueOrDefaultUnsupported(this.languageContext, receiver, key, defaultValue);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException getHashValueOrDefaultUnsupported(PolyglotLanguageContext context, Object receiver, Object key, Object defaultValue) {
        throw PolyglotValue.unsupported(context, receiver, "getHashValueOrDefault(Object, Object)", "hasHashEntries()");
    }

    public void putHashEntry(Object receiver, Object key, Object value) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            PolyglotValue.putHashEntryUnsupported(this.languageContext, receiver, key, value);
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException putHashEntryUnsupported(PolyglotLanguageContext context, Object receiver, Object key, Object value) {
        throw PolyglotValue.unsupported(context, receiver, "putHashEntry(Object, Object)", "hasHashEntries()");
    }

    public boolean removeHashEntry(Object receiver, Object key) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.removeHashEntryUnsupported(this.languageContext, receiver, key);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException removeHashEntryUnsupported(PolyglotLanguageContext context, Object receiver, Object key) {
        throw PolyglotValue.unsupported(context, receiver, "removeHashEntry(Object)", "hasHashEntries()");
    }

    public Value getHashEntriesIterator(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.getHashEntriesIteratorUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException getHashEntriesIteratorUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "getHashEntriesIterator()", "hasHashEntries()");
    }

    public Value getHashKeysIterator(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.getHashKeysIteratorUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException getHashKeysIteratorUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "getHashKeysIterator()", "hasHashEntries()");
    }

    public Value getHashValuesIterator(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.getHashValuesIteratorUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException getHashValuesIteratorUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "getHashValuesIterator()", "hasHashEntries()");
    }

    protected Value getMetaObjectImpl(Object receiver) {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
        if (lib.hasMetaObject(receiver)) {
            try {
                return this.asValue(lib.getMetaObject(receiver));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere("Unexpected unsupported message.", e);
            }
        }
        return null;
    }

    private Value asValue(Object value) {
        if (this.languageContext == null) {
            return PolyglotImpl.getInstance().asValue(PolyglotContextImpl.currentNotEntered(), value);
        }
        return this.languageContext.asValue(value);
    }

    static Object hostEnter(PolyglotLanguageContext languageContext) {
        if (languageContext == null) {
            return null;
        }
        try {
            return languageContext.context.engine.enterIfNeeded(languageContext.context, true);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(languageContext, t, false);
        }
    }

    static void hostLeave(PolyglotLanguageContext languageContext, Object prev) {
        if (languageContext == null) {
            return;
        }
        try {
            languageContext.context.engine.leaveIfNeeded(prev, languageContext.context);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(languageContext, t, false);
        }
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException unsupported(PolyglotLanguageContext languageContext, Object receiver, String message, String useToCheck) {
        assert (languageContext == null || !languageContext.context.engine.needsEnter(languageContext.context));
        String polyglotMessage = useToCheck != null ? String.format("Unsupported operation %s.%s for %s. You can ensure that the operation is supported using %s.%s.", Value.class.getSimpleName(), message, PolyglotValue.getValueInfo(languageContext, receiver), Value.class.getSimpleName(), useToCheck) : String.format("Unsupported operation %s.%s for %s.", Value.class.getSimpleName(), message, PolyglotValue.getValueInfo(languageContext, receiver));
        return PolyglotEngineException.unsupported(polyglotMessage);
    }

    @CompilerDirectives.TruffleBoundary
    static String getValueInfo(PolyglotLanguageContext languageContext, Object receiver) {
        String valueToString;
        Object view;
        if (languageContext == null) {
            return receiver.toString();
        }
        if (receiver == null) {
            assert (false) : "receiver should never be null";
            return "null";
        }
        PolyglotContextImpl context = languageContext.context;
        PolyglotLanguage displayLanguage = EngineAccessor.EngineImpl.findObjectLanguage(context.engine, receiver);
        if (displayLanguage == null) {
            displayLanguage = context.engine.hostLanguage;
            view = context.getHostContext().getLanguageView(receiver);
        } else {
            view = receiver;
        }
        String metaObjectToString = UNKNOWN;
        try {
            InteropLibrary uncached = InteropLibrary.getFactory().getUncached(view);
            if (uncached.hasMetaObject(view)) {
                Object qualifiedName = INTEROP.getMetaQualifiedName(uncached.getMetaObject(view));
                metaObjectToString = PolyglotValue.truncateString(INTEROP.asString(qualifiedName), 140);
            }
            valueToString = PolyglotValue.truncateString(INTEROP.asString(uncached.toDisplayString(view)), 140);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
        String languageName = null;
        boolean hideType = false;
        if (displayLanguage.isHost()) {
            languageName = "Java";
            if (UNKNOWN.equals(metaObjectToString) && INTEROP.isNull(receiver)) {
                hideType = true;
            }
        } else {
            languageName = displayLanguage.getName();
        }
        if (hideType) {
            return String.format("'%s'(language: %s)", valueToString, languageName);
        }
        return String.format("'%s'(language: %s, type: %s)", valueToString, languageName, metaObjectToString);
    }

    private static String truncateString(String s, int i) {
        if (s.length() > i) {
            return s.substring(0, i - TRUNCATION_SUFFIX.length()) + TRUNCATION_SUFFIX;
        }
        return s;
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException nullCoercion(PolyglotLanguageContext languageContext, Object receiver, Class<?> targetType, String message, String useToCheck) {
        assert (languageContext == null || !languageContext.context.engine.needsEnter(languageContext.context));
        String valueInfo = PolyglotValue.getValueInfo(languageContext, receiver);
        throw PolyglotEngineException.nullPointer(String.format("Cannot convert null value %s to Java type '%s' using %s.%s. You can ensure that the operation is supported using %s.%s.", valueInfo, targetType, Value.class.getSimpleName(), message, Value.class.getSimpleName(), useToCheck));
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException cannotConvert(PolyglotLanguageContext languageContext, Object receiver, Class<?> targetType, String message, String useToCheck, String reason) {
        assert (languageContext == null || !languageContext.context.engine.needsEnter(languageContext.context));
        String valueInfo = PolyglotValue.getValueInfo(languageContext, receiver);
        String targetTypeString = "";
        if (targetType != null) {
            targetTypeString = String.format("to Java type '%s'", targetType.getTypeName());
        }
        throw PolyglotEngineException.classCast(String.format("Cannot convert %s %s using %s.%s: %s You can ensure that the value can be converted using %s.%s.", valueInfo, targetTypeString, Value.class.getSimpleName(), message, reason, Value.class.getSimpleName(), useToCheck));
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidArrayIndex(PolyglotLanguageContext context, Object receiver, long index) {
        String message = String.format("Invalid array index %s for array %s.", index, PolyglotValue.getValueInfo(context, receiver));
        throw PolyglotEngineException.arrayIndexOutOfBounds(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidArrayValue(PolyglotLanguageContext context, Object receiver, long identifier, Object value) {
        throw PolyglotEngineException.classCast(String.format("Invalid array value %s for array %s and index %s.", PolyglotValue.getValueInfo(context, value), PolyglotValue.getValueInfo(context, receiver), identifier));
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException nonReadableMemberKey(PolyglotLanguageContext context, Object receiver, String identifier) {
        String message = String.format("Non readable or non-existent member key '%s' for object %s.", identifier, PolyglotValue.getValueInfo(context, receiver));
        throw PolyglotEngineException.unsupported(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException nonWritableMemberKey(PolyglotLanguageContext context, Object receiver, String identifier) {
        String message = String.format("Non writable or non-existent member key '%s' for object %s.", identifier, PolyglotValue.getValueInfo(context, receiver));
        throw PolyglotEngineException.unsupported(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException nonRemovableMemberKey(PolyglotLanguageContext context, Object receiver, String identifier) {
        String message = String.format("Non removable or non-existent member key '%s' for object %s.", identifier, PolyglotValue.getValueInfo(context, receiver));
        throw PolyglotEngineException.unsupported(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidMemberValue(PolyglotLanguageContext context, Object receiver, String identifier, Object value) {
        String message = String.format("Invalid member value %s for object %s and member key '%s'.", PolyglotValue.getValueInfo(context, value), PolyglotValue.getValueInfo(context, receiver), identifier);
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException stopIteration(PolyglotLanguageContext context, Object receiver) {
        String message = String.format("Iteration was stopped for iterator %s.", PolyglotValue.getValueInfo(context, receiver));
        throw PolyglotEngineException.noSuchElement(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException nonReadableIteratorElement() {
        throw PolyglotEngineException.unsupported("Iterator element is not readable.");
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidHashValue(PolyglotLanguageContext context, Object receiver, Object key, Object value) {
        String message = String.format("Invalid hash value %s for object %s and hash key %s.", PolyglotValue.getValueInfo(context, value), PolyglotValue.getValueInfo(context, receiver), PolyglotValue.getValueInfo(context, key));
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidExecuteArgumentType(PolyglotLanguageContext context, Object receiver, UnsupportedTypeException e) {
        String originalMessage = e.getMessage() == null ? "" : e.getMessage() + " ";
        String[] formattedArgs = PolyglotValue.formatArgs(context, e.getSuppliedValues());
        throw PolyglotEngineException.illegalArgument(String.format("Invalid argument when executing %s. %sProvided arguments: %s.", PolyglotValue.getValueInfo(context, receiver), originalMessage, Arrays.asList(formattedArgs)));
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidInvokeArgumentType(PolyglotLanguageContext context, Object receiver, String member, UnsupportedTypeException e) {
        String originalMessage = e.getMessage() == null ? "" : e.getMessage();
        String[] formattedArgs = PolyglotValue.formatArgs(context, e.getSuppliedValues());
        String message = String.format("Invalid argument when invoking '%s' on %s. %sProvided arguments: %s.", member, PolyglotValue.getValueInfo(context, receiver), originalMessage, Arrays.asList(formattedArgs));
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidInstantiateArgumentType(PolyglotLanguageContext context, Object receiver, Object[] arguments) {
        String[] formattedArgs = PolyglotValue.formatArgs(context, arguments);
        String message = String.format("Invalid argument when instantiating %s with arguments %s.", PolyglotValue.getValueInfo(context, receiver), Arrays.asList(formattedArgs));
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidInstantiateArity(PolyglotLanguageContext context, Object receiver, Object[] arguments, int expected, int actual) {
        String[] formattedArgs = PolyglotValue.formatArgs(context, arguments);
        String message = String.format("Invalid argument count when instantiating %s with arguments %s. Expected %d argument(s) but got %d.", PolyglotValue.getValueInfo(context, receiver), Arrays.asList(formattedArgs), expected, actual);
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidExecuteArity(PolyglotLanguageContext context, Object receiver, Object[] arguments, int expected, int actual) {
        String[] formattedArgs = PolyglotValue.formatArgs(context, arguments);
        String message = String.format("Invalid argument count when executing %s with arguments %s. Expected %d argument(s) but got %d.", PolyglotValue.getValueInfo(context, receiver), Arrays.asList(formattedArgs), expected, actual);
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidInvokeArity(PolyglotLanguageContext context, Object receiver, String member, Object[] arguments, int expected, int actual) {
        String[] formattedArgs = PolyglotValue.formatArgs(context, arguments);
        String message = String.format("Invalid argument count when invoking '%s' on %s with arguments %s. Expected %d argument(s) but got %d.", member, PolyglotValue.getValueInfo(context, receiver), Arrays.asList(formattedArgs), expected, actual);
        throw PolyglotEngineException.illegalArgument(message);
    }

    private static String[] formatArgs(PolyglotLanguageContext context, Object[] arguments) {
        String[] formattedArgs = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            formattedArgs[i] = PolyglotValue.getValueInfo(context, arguments[i]);
        }
        return formattedArgs;
    }

    public final String toString(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            String string = this.toStringImpl(receiver);
            return string;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected String toStringImpl(Object receiver) throws AssertionError {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
        Object result = lib.toDisplayString(receiver);
        InteropLibrary resultLib = InteropLibrary.getFactory().getUncached(result);
        try {
            return resultLib.asString(result);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere("toDisplayString must be coercible to java.lang.String, but is not.", e);
        }
    }

    public org.graalvm.polyglot.SourceSection getSourceLocation(Object receiver) {
        if (this.languageContext == null) {
            return null;
        }
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
            SourceSection result = null;
            if (lib.hasSourceLocation(receiver)) {
                try {
                    result = lib.getSourceLocation(receiver);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            if (result == null) {
                org.graalvm.polyglot.SourceSection sourceSection = null;
                return sourceSection;
            }
            org.graalvm.polyglot.SourceSection sourceSection = this.languageContext.getImpl().getPolyglotSourceSection(result);
            return sourceSection;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    public boolean isMetaObject(Object receiver) {
        return false;
    }

    public boolean equalsImpl(Object receiver, Object obj) {
        if (receiver == obj) {
            return true;
        }
        return HostWrapper.equals(this.languageContext, receiver, obj);
    }

    public int hashCodeImpl(Object receiver) {
        return HostWrapper.hashCode(this.languageContext, receiver);
    }

    public boolean isMetaInstance(Object receiver, Object instance) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.unsupported(this.languageContext, receiver, "isMetaInstance(Object)", "isMetaObject()");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    public String getMetaQualifiedName(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.unsupported(this.languageContext, receiver, "getMetaQualifiedName()", "isMetaObject()");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    public String getMetaSimpleName(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.unsupported(this.languageContext, receiver, "getMetaSimpleName()", "isMetaObject()");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    static CallTarget createTarget(InteropNode root) {
        RootCallTarget target = Truffle.getRuntime().createCallTarget(root);
        Class<?>[] types = root.getArgumentTypes();
        if (types != null) {
            EngineAccessor.RUNTIME.initializeProfile(target, types);
        }
        return target;
    }

    static PolyglotValue createInteropValue(PolyglotLanguageContext languageContext, TruffleObject receiver, Class<?> receiverType) {
        PolyglotLanguageInstance languageInstance = languageContext.getLanguageInstance();
        InteropCodeCache cache = languageInstance.valueCodeCache.get(receiverType);
        if (cache == null) {
            cache = new InteropCodeCache(languageInstance, receiver, receiverType);
            languageInstance.valueCodeCache.put(receiverType, cache);
        }
        return new InteropValue(languageContext, cache);
    }

    static PolyglotValue createHostNull(PolyglotImpl polyglot) {
        return new HostNull(polyglot);
    }

    static void createDefaultValues(PolyglotImpl polyglot, PolyglotLanguageContext context, Map<Class<?>, PolyglotValue> valueCache) {
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, false);
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, "");
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, Character.valueOf('a'));
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, (byte)0);
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, (short)0);
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, 0);
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, 0L);
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, Float.valueOf(0.0f));
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, 0.0);
    }

    static void addDefaultValue(PolyglotImpl polyglot, PolyglotLanguageContext context, Map<Class<?>, PolyglotValue> valueCache, Object primitive) {
        valueCache.put(primitive.getClass(), new PrimitiveValue(polyglot, context, primitive));
    }

    private static final class InteropValue
    extends PolyglotValue {
        private final InteropCodeCache cache;

        InteropValue(PolyglotLanguageContext context, InteropCodeCache codeCache) {
            super(context);
            this.cache = codeCache;
        }

        public <T> T as(Object receiver, Class<T> targetType) {
            return (T)EngineAccessor.RUNTIME.callProfiled(this.cache.asClassLiteral, this.languageContext, receiver, targetType);
        }

        public <T> T as(Object receiver, TypeLiteral<T> targetType) {
            return (T)EngineAccessor.RUNTIME.callProfiled(this.cache.asTypeLiteral, this.languageContext, receiver, targetType);
        }

        public boolean isNativePointer(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isNativePointer, this.languageContext, receiver);
        }

        public boolean hasArrayElements(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.hasArrayElements, this.languageContext, receiver);
        }

        @Override
        public Value getArrayElement(Object receiver, long index) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getArrayElement, this.languageContext, receiver, index);
        }

        @Override
        public void setArrayElement(Object receiver, long index, Object value) {
            EngineAccessor.RUNTIME.callProfiled(this.cache.setArrayElement, this.languageContext, receiver, index, value);
        }

        @Override
        public boolean removeArrayElement(Object receiver, long index) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.removeArrayElement, this.languageContext, receiver, index);
        }

        @Override
        public long getArraySize(Object receiver) {
            return (Long)EngineAccessor.RUNTIME.callProfiled(this.cache.getArraySize, this.languageContext, receiver);
        }

        public boolean hasBufferElements(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.hasBufferElements, this.languageContext, receiver);
        }

        @Override
        public boolean isBufferWritable(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isBufferWritable, this.languageContext, receiver);
        }

        @Override
        public long getBufferSize(Object receiver) throws UnsupportedOperationException {
            return (Long)EngineAccessor.RUNTIME.callProfiled(this.cache.getBufferSize, this.languageContext, receiver);
        }

        @Override
        public byte readBufferByte(Object receiver, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
            return (Byte)EngineAccessor.RUNTIME.callProfiled(this.cache.readBufferByte, this.languageContext, receiver, byteOffset);
        }

        @Override
        public void writeBufferByte(Object receiver, long byteOffset, byte value) throws UnsupportedOperationException, IndexOutOfBoundsException {
            EngineAccessor.RUNTIME.callProfiled(this.cache.writeBufferByte, this.languageContext, receiver, byteOffset, value);
        }

        @Override
        public short readBufferShort(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
            return (Short)EngineAccessor.RUNTIME.callProfiled(this.cache.readBufferShort, this.languageContext, receiver, order, byteOffset);
        }

        @Override
        public void writeBufferShort(Object receiver, ByteOrder order, long byteOffset, short value) throws UnsupportedOperationException, IndexOutOfBoundsException {
            EngineAccessor.RUNTIME.callProfiled(this.cache.writeBufferShort, this.languageContext, receiver, order, byteOffset, value);
        }

        @Override
        public int readBufferInt(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
            return (Integer)EngineAccessor.RUNTIME.callProfiled(this.cache.readBufferInt, this.languageContext, receiver, order, byteOffset);
        }

        @Override
        public void writeBufferInt(Object receiver, ByteOrder order, long byteOffset, int value) throws UnsupportedOperationException, IndexOutOfBoundsException {
            EngineAccessor.RUNTIME.callProfiled(this.cache.writeBufferInt, this.languageContext, receiver, order, byteOffset, value);
        }

        @Override
        public long readBufferLong(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
            return (Long)EngineAccessor.RUNTIME.callProfiled(this.cache.readBufferLong, this.languageContext, receiver, order, byteOffset);
        }

        @Override
        public void writeBufferLong(Object receiver, ByteOrder order, long byteOffset, long value) throws UnsupportedOperationException, IndexOutOfBoundsException {
            EngineAccessor.RUNTIME.callProfiled(this.cache.writeBufferLong, this.languageContext, receiver, order, byteOffset, value);
        }

        @Override
        public float readBufferFloat(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
            return ((Float)EngineAccessor.RUNTIME.callProfiled(this.cache.readBufferFloat, this.languageContext, receiver, order, byteOffset)).floatValue();
        }

        @Override
        public void writeBufferFloat(Object receiver, ByteOrder order, long byteOffset, float value) throws UnsupportedOperationException, IndexOutOfBoundsException {
            EngineAccessor.RUNTIME.callProfiled(this.cache.writeBufferFloat, this.languageContext, receiver, order, byteOffset, Float.valueOf(value));
        }

        @Override
        public double readBufferDouble(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
            return (Double)EngineAccessor.RUNTIME.callProfiled(this.cache.readBufferDouble, this.languageContext, receiver, order, byteOffset);
        }

        @Override
        public void writeBufferDouble(Object receiver, ByteOrder order, long byteOffset, double value) throws UnsupportedOperationException, IndexOutOfBoundsException {
            EngineAccessor.RUNTIME.callProfiled(this.cache.writeBufferDouble, this.languageContext, receiver, order, byteOffset, value);
        }

        public boolean hasMembers(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.hasMembers, this.languageContext, receiver);
        }

        @Override
        public Value getMember(Object receiver, String key) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getMember, this.languageContext, receiver, key);
        }

        public boolean hasMember(Object receiver, String key) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.hasMember, this.languageContext, receiver, key);
        }

        @Override
        public void putMember(Object receiver, String key, Object member) {
            EngineAccessor.RUNTIME.callProfiled(this.cache.putMember, this.languageContext, receiver, key, member);
        }

        @Override
        public boolean removeMember(Object receiver, String key) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.removeMember, this.languageContext, receiver, key);
        }

        public Set<String> getMemberKeys(Object receiver) {
            Value keys = (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getMemberKeys, this.languageContext, receiver);
            if (keys == null) {
                return Collections.emptySet();
            }
            return new MemberSet(receiver, keys);
        }

        @Override
        public long asNativePointer(Object receiver) {
            return (Long)EngineAccessor.RUNTIME.callProfiled(this.cache.asNativePointer, this.languageContext, receiver);
        }

        public boolean isDate(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isDate, this.languageContext, receiver);
        }

        @Override
        public LocalDate asDate(Object receiver) {
            return (LocalDate)EngineAccessor.RUNTIME.callProfiled(this.cache.asDate, this.languageContext, receiver);
        }

        public boolean isTime(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isTime, this.languageContext, receiver);
        }

        @Override
        public LocalTime asTime(Object receiver) {
            return (LocalTime)EngineAccessor.RUNTIME.callProfiled(this.cache.asTime, this.languageContext, receiver);
        }

        public boolean isTimeZone(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isTimeZone, this.languageContext, receiver);
        }

        @Override
        public ZoneId asTimeZone(Object receiver) {
            return (ZoneId)EngineAccessor.RUNTIME.callProfiled(this.cache.asTimeZone, this.languageContext, receiver);
        }

        @Override
        public Instant asInstant(Object receiver) {
            return (Instant)EngineAccessor.RUNTIME.callProfiled(this.cache.asInstant, this.languageContext, receiver);
        }

        public boolean isDuration(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isDuration, this.languageContext, receiver);
        }

        @Override
        public Duration asDuration(Object receiver) {
            return (Duration)EngineAccessor.RUNTIME.callProfiled(this.cache.asDuration, this.languageContext, receiver);
        }

        public boolean isHostObject(Object receiver) {
            return this.cache.isHost;
        }

        public boolean isProxyObject(Object receiver) {
            return this.cache.isProxy;
        }

        @Override
        public Object asProxyObject(Object receiver) {
            if (this.cache.isProxy) {
                return PolyglotProxy.toProxyHostObject((TruffleObject)receiver);
            }
            return super.asProxyObject(receiver);
        }

        @Override
        public Object asHostObject(Object receiver) {
            if (this.cache.isHost) {
                return HostObject.valueOf(receiver);
            }
            return super.asHostObject(receiver);
        }

        public boolean isNull(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isNull, this.languageContext, receiver);
        }

        public boolean canExecute(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.canExecute, this.languageContext, receiver);
        }

        @Override
        public void executeVoid(Object receiver, Object[] arguments) {
            EngineAccessor.RUNTIME.callProfiled(this.cache.executeVoid, this.languageContext, receiver, arguments);
        }

        @Override
        public void executeVoid(Object receiver) {
            EngineAccessor.RUNTIME.callProfiled(this.cache.executeVoidNoArgs, this.languageContext, receiver);
        }

        @Override
        public Value execute(Object receiver, Object[] arguments) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.execute, this.languageContext, receiver, arguments);
        }

        @Override
        public Value execute(Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.executeNoArgs, this.languageContext, receiver);
        }

        public boolean canInstantiate(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.canInstantiate, this.languageContext, receiver);
        }

        @Override
        public Value newInstance(Object receiver, Object[] arguments) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.newInstance, this.languageContext, receiver, arguments);
        }

        public boolean canInvoke(String identifier, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.canInvoke, this.languageContext, receiver, identifier);
        }

        @Override
        public Value invoke(Object receiver, String identifier, Object[] arguments) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.invoke, this.languageContext, receiver, identifier, arguments);
        }

        @Override
        public Value invoke(Object receiver, String identifier) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.invokeNoArgs, this.languageContext, receiver, identifier);
        }

        public boolean isException(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isException, this.languageContext, receiver);
        }

        @Override
        public RuntimeException throwException(Object receiver) {
            EngineAccessor.RUNTIME.callProfiled(this.cache.throwException, this.languageContext, receiver);
            throw super.throwException(receiver);
        }

        public boolean isNumber(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.isNumber(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        public boolean fitsInByte(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInByte(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public byte asByte(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                byte by = UNCACHED_INTEROP.asByte(receiver);
                return by;
            }
            catch (UnsupportedMessageException e) {
                byte by = this.asByteUnsupported(receiver);
                return by;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        public boolean isString(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.isString(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public String asString(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                if (PolyglotValue.isNullUncached(receiver)) {
                    String string = null;
                    return string;
                }
                String string = UNCACHED_INTEROP.asString(receiver);
                return string;
            }
            catch (UnsupportedMessageException e) {
                String string = this.asStringUnsupported(receiver);
                return string;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        public boolean fitsInInt(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInInt(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public int asInt(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                int n = UNCACHED_INTEROP.asInt(receiver);
                return n;
            }
            catch (UnsupportedMessageException e) {
                int n = this.asIntUnsupported(receiver);
                return n;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        public boolean isBoolean(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = InteropLibrary.getFactory().getUncached().isBoolean(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public boolean asBoolean(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = InteropLibrary.getFactory().getUncached().asBoolean(receiver);
                return bl;
            }
            catch (UnsupportedMessageException e) {
                boolean bl = this.asBooleanUnsupported(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        public boolean fitsInFloat(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = InteropLibrary.getFactory().getUncached().fitsInFloat(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public float asFloat(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                float f = UNCACHED_INTEROP.asFloat(receiver);
                return f;
            }
            catch (UnsupportedMessageException e) {
                float f = this.asFloatUnsupported(receiver);
                return f;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        public boolean fitsInDouble(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInDouble(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public double asDouble(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                double d = UNCACHED_INTEROP.asDouble(receiver);
                return d;
            }
            catch (UnsupportedMessageException e) {
                double d = this.asDoubleUnsupported(receiver);
                return d;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        public boolean fitsInLong(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInLong(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public long asLong(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                long l = UNCACHED_INTEROP.asLong(receiver);
                return l;
            }
            catch (UnsupportedMessageException e) {
                long l = this.asLongUnsupported(receiver);
                return l;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        public boolean fitsInShort(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInShort(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public short asShort(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                short s = UNCACHED_INTEROP.asShort(receiver);
                return s;
            }
            catch (UnsupportedMessageException e) {
                short s = this.asShortUnsupported(receiver);
                return s;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public boolean isMetaObject(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isMetaObject, this.languageContext, receiver);
        }

        @Override
        public boolean isMetaInstance(Object receiver, Object instance) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isMetaInstance, this.languageContext, receiver, instance);
        }

        @Override
        public String getMetaQualifiedName(Object receiver) {
            return (String)EngineAccessor.RUNTIME.callProfiled(this.cache.getMetaQualifiedName, this.languageContext, receiver);
        }

        @Override
        public String getMetaSimpleName(Object receiver) {
            return (String)EngineAccessor.RUNTIME.callProfiled(this.cache.getMetaSimpleName, this.languageContext, receiver);
        }

        public boolean hasIterator(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.hasIterator, this.languageContext, receiver);
        }

        @Override
        public Value getIterator(Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getIterator, this.languageContext, receiver);
        }

        public boolean isIterator(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isIterator, this.languageContext, receiver);
        }

        @Override
        public boolean hasIteratorNextElement(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.hasIteratorNextElement, this.languageContext, receiver);
        }

        @Override
        public Value getIteratorNextElement(Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getIteratorNextElement, this.languageContext, receiver);
        }

        public boolean hasHashEntries(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.hasHashEntries, this.languageContext, receiver);
        }

        @Override
        public long getHashSize(Object receiver) {
            return (Long)EngineAccessor.RUNTIME.callProfiled(this.cache.getHashSize, this.languageContext, receiver);
        }

        public boolean hasHashEntry(Object receiver, Object key) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.hasHashEntry, this.languageContext, receiver, key);
        }

        @Override
        public Value getHashValue(Object receiver, Object key) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getHashValue, this.languageContext, receiver, key);
        }

        @Override
        public Value getHashValueOrDefault(Object receiver, Object key, Object defaultValue) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getHashValueOrDefault, this.languageContext, receiver, key, defaultValue);
        }

        @Override
        public void putHashEntry(Object receiver, Object key, Object value) {
            EngineAccessor.RUNTIME.callProfiled(this.cache.putHashEntry, this.languageContext, receiver, key, value);
        }

        @Override
        public boolean removeHashEntry(Object receiver, Object key) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.removeHashEntry, this.languageContext, receiver, key);
        }

        @Override
        public Value getHashEntriesIterator(Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getHashEntriesIterator, this.languageContext, receiver);
        }

        @Override
        public Value getHashKeysIterator(Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getHashKeysIterator, this.languageContext, receiver);
        }

        @Override
        public Value getHashValuesIterator(Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getHashValuesIterator, this.languageContext, receiver);
        }

        private final class MemberSet
        extends AbstractSet<String> {
            private final Object receiver;
            private final Value keys;
            private int cachedSize = -1;

            MemberSet(Object receiver, Value keys) {
                this.receiver = receiver;
                this.keys = keys;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof String)) {
                    return false;
                }
                return InteropValue.this.hasMember(this.receiver, (String)o);
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < MemberSet.this.size();
                    }

                    @Override
                    public String next() {
                        if (this.index >= MemberSet.this.size()) {
                            throw new NoSuchElementException();
                        }
                        Value arrayElement = MemberSet.this.keys.getArrayElement((long)this.index++);
                        if (arrayElement.isString()) {
                            return arrayElement.asString();
                        }
                        return null;
                    }
                };
            }

            @Override
            public int size() {
                int size = this.cachedSize;
                if (size != -1) {
                    return size;
                }
                this.cachedSize = size = (int)this.keys.getArraySize();
                return size;
            }
        }
    }

    static final class HostValue
    extends PolyglotValue {
        HostValue(PolyglotImpl polyglot) {
            super(polyglot, null);
        }

        public boolean isHostObject(Object receiver) {
            return HostObject.isInstance(receiver);
        }

        @Override
        public Object asHostObject(Object receiver) {
            return HostObject.valueOf(receiver);
        }

        public boolean isProxyObject(Object receiver) {
            return PolyglotProxy.isProxyGuestObject(receiver);
        }

        @Override
        public Object asProxyObject(Object receiver) {
            return PolyglotProxy.toProxyHostObject((TruffleObject)receiver);
        }

        public <T> T as(Object receiver, Class<T> targetType) {
            return this.asImpl(receiver, targetType);
        }

        public <T> T as(Object receiver, TypeLiteral<T> targetType) {
            return this.asImpl(receiver, targetType.getRawType());
        }

        <T> T asImpl(Object receiver, Class<T> targetType) {
            Object hostValue;
            if (this.isProxyObject(receiver)) {
                hostValue = this.asProxyObject(receiver);
            } else if (this.isHostObject(receiver)) {
                hostValue = this.asHostObject(receiver);
            } else {
                throw new ClassCastException();
            }
            return targetType.cast(hostValue);
        }
    }

    static abstract class InteropNode
    extends HostToGuestRootNode {
        protected static final int CACHE_LIMIT = 5;
        protected final InteropCodeCache polyglot;

        protected abstract String getOperationName();

        protected InteropNode(InteropCodeCache polyglot) {
            this.polyglot = polyglot;
        }

        protected abstract Class<?>[] getArgumentTypes();

        protected Class<? extends Object> getReceiverType() {
            return this.polyglot.receiverType;
        }

        protected final PolyglotLanguageContext.ToHostValueNode createToHost() {
            return PolyglotLanguageContext.ToHostValueNode.create(this.getImpl());
        }

        @Override
        public final String getName() {
            return "org.graalvm.polyglot.Value<" + this.polyglot.receiverType.getSimpleName() + ">." + this.getOperationName();
        }

        protected final PolyglotImpl getImpl() {
            return this.polyglot.languageInstance.language.getImpl();
        }

        @Override
        public final String toString() {
            return this.getName();
        }
    }

    private static final class HostNull
    extends PolyglotValue {
        private final PolyglotImpl polyglot;

        HostNull(PolyglotImpl polyglot) {
            super(polyglot, null);
            this.polyglot = polyglot;
        }

        public boolean isNull(Object receiver) {
            return true;
        }

        public <T> T as(Object receiver, Class<T> targetType) {
            if (targetType == Value.class) {
                return (T)this.polyglot.hostNull;
            }
            return null;
        }

        public <T> T as(Object receiver, TypeLiteral<T> targetType) {
            return this.as(receiver, targetType.getRawType());
        }
    }

    static final class PrimitiveValue
    extends PolyglotValue {
        private final InteropLibrary interop;

        PrimitiveValue(PolyglotImpl polyglot, PolyglotLanguageContext context, Object primitiveValue) {
            super(polyglot, context);
            this.interop = InteropLibrary.getFactory().getUncached(primitiveValue);
        }

        public boolean isString(Object receiver) {
            return this.interop.isString(receiver);
        }

        public boolean isBoolean(Object receiver) {
            return this.interop.isBoolean(receiver);
        }

        @Override
        public boolean asBoolean(Object receiver) {
            try {
                return this.interop.asBoolean(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asBoolean(receiver);
            }
        }

        @Override
        public String asString(Object receiver) {
            try {
                return this.interop.asString(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asString(receiver);
            }
        }

        public boolean isNumber(Object receiver) {
            return this.interop.isNumber(receiver);
        }

        public boolean fitsInByte(Object receiver) {
            return this.interop.fitsInByte(receiver);
        }

        public boolean fitsInShort(Object receiver) {
            return this.interop.fitsInShort(receiver);
        }

        public boolean fitsInInt(Object receiver) {
            return this.interop.fitsInInt(receiver);
        }

        public boolean fitsInLong(Object receiver) {
            return this.interop.fitsInLong(receiver);
        }

        public boolean fitsInFloat(Object receiver) {
            return this.interop.fitsInFloat(receiver);
        }

        public boolean fitsInDouble(Object receiver) {
            return this.interop.fitsInDouble(receiver);
        }

        @Override
        public byte asByte(Object receiver) {
            try {
                return this.interop.asByte(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asByte(receiver);
            }
        }

        @Override
        public short asShort(Object receiver) {
            try {
                return this.interop.asShort(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asShort(receiver);
            }
        }

        @Override
        public int asInt(Object receiver) {
            try {
                return this.interop.asInt(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asInt(receiver);
            }
        }

        @Override
        public long asLong(Object receiver) {
            try {
                return this.interop.asLong(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asLong(receiver);
            }
        }

        @Override
        public float asFloat(Object receiver) {
            try {
                return this.interop.asFloat(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asFloat(receiver);
            }
        }

        @Override
        public double asDouble(Object receiver) {
            try {
                return this.interop.asDouble(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asDouble(receiver);
            }
        }

        public <T> T as(Object receiver, Class<T> targetType) {
            Object prev = PrimitiveValue.hostEnter(this.languageContext);
            try {
                Object object = ToHostNodeGen.getUncached().execute(receiver, targetType, targetType, this.languageContext, true);
                return (T)object;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                PrimitiveValue.hostLeave(this.languageContext, prev);
            }
        }

        public <T> T as(Object receiver, TypeLiteral<T> targetType) {
            return this.as(receiver, targetType.getRawType());
        }

        @Override
        public Value getMetaObjectImpl(Object receiver) {
            return super.getMetaObjectImpl(this.getLanguageView(receiver));
        }

        @Override
        protected String toStringImpl(Object receiver) throws AssertionError {
            return super.toStringImpl(this.getLanguageView(receiver));
        }

        private Object getLanguageView(Object receiver) {
            if (this.languageContext == null) {
                return receiver;
            }
            return this.languageContext.getLanguageViewNoCheck(receiver);
        }
    }

    static class InteropCodeCache {
        final CallTarget isNativePointer;
        final CallTarget asNativePointer;
        final CallTarget hasArrayElements;
        final CallTarget getArrayElement;
        final CallTarget setArrayElement;
        final CallTarget removeArrayElement;
        final CallTarget getArraySize;
        final CallTarget hasBufferElements;
        final CallTarget isBufferWritable;
        final CallTarget getBufferSize;
        final CallTarget readBufferByte;
        final CallTarget writeBufferByte;
        final CallTarget readBufferShort;
        final CallTarget writeBufferShort;
        final CallTarget readBufferInt;
        final CallTarget writeBufferInt;
        final CallTarget readBufferLong;
        final CallTarget writeBufferLong;
        final CallTarget readBufferFloat;
        final CallTarget writeBufferFloat;
        final CallTarget readBufferDouble;
        final CallTarget writeBufferDouble;
        final CallTarget hasMembers;
        final CallTarget hasMember;
        final CallTarget getMember;
        final CallTarget putMember;
        final CallTarget removeMember;
        final CallTarget isNull;
        final CallTarget canExecute;
        final CallTarget execute;
        final CallTarget canInstantiate;
        final CallTarget newInstance;
        final CallTarget executeNoArgs;
        final CallTarget executeVoid;
        final CallTarget executeVoidNoArgs;
        final CallTarget canInvoke;
        final CallTarget invoke;
        final CallTarget invokeNoArgs;
        final CallTarget getMemberKeys;
        final CallTarget isDate;
        final CallTarget asDate;
        final CallTarget isTime;
        final CallTarget asTime;
        final CallTarget isTimeZone;
        final CallTarget asTimeZone;
        final CallTarget asInstant;
        final CallTarget isDuration;
        final CallTarget asDuration;
        final CallTarget isException;
        final CallTarget throwException;
        final CallTarget isMetaObject;
        final CallTarget isMetaInstance;
        final CallTarget getMetaQualifiedName;
        final CallTarget getMetaSimpleName;
        final CallTarget hasIterator;
        final CallTarget getIterator;
        final CallTarget isIterator;
        final CallTarget hasIteratorNextElement;
        final CallTarget getIteratorNextElement;
        final CallTarget hasHashEntries;
        final CallTarget getHashSize;
        final CallTarget hasHashEntry;
        final CallTarget getHashValue;
        final CallTarget getHashValueOrDefault;
        final CallTarget putHashEntry;
        final CallTarget removeHashEntry;
        final CallTarget getHashEntriesIterator;
        final CallTarget getHashKeysIterator;
        final CallTarget getHashValuesIterator;
        final boolean isProxy;
        final boolean isHost;
        final CallTarget asClassLiteral;
        final CallTarget asTypeLiteral;
        final Class<?> receiverType;
        final PolyglotLanguageInstance languageInstance;

        InteropCodeCache(PolyglotLanguageInstance languageInstance, TruffleObject receiverObject, Class<?> receiverType) {
            Objects.requireNonNull(receiverType);
            this.languageInstance = languageInstance;
            this.receiverType = receiverType;
            this.asClassLiteral = PolyglotValue.createTarget(new AsClassLiteralNode(this));
            this.asTypeLiteral = PolyglotValue.createTarget(new AsTypeLiteralNode(this));
            this.isNativePointer = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsNativePointerNodeGen.create(this));
            this.asNativePointer = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.AsNativePointerNodeGen.create(this));
            this.hasArrayElements = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.HasArrayElementsNodeGen.create(this));
            this.getArrayElement = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetArrayElementNodeGen.create(this));
            this.setArrayElement = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.SetArrayElementNodeGen.create(this));
            this.removeArrayElement = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.RemoveArrayElementNodeGen.create(this));
            this.getArraySize = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetArraySizeNodeGen.create(this));
            this.hasBufferElements = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.HasBufferElementsNodeGen.create(this));
            this.isBufferWritable = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsBufferWritableNodeGen.create(this));
            this.getBufferSize = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetBufferSizeNodeGen.create(this));
            this.readBufferByte = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.ReadBufferByteNodeGen.create(this));
            this.writeBufferByte = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.WriteBufferByteNodeGen.create(this));
            this.readBufferShort = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.ReadBufferShortNodeGen.create(this));
            this.writeBufferShort = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.WriteBufferShortNodeGen.create(this));
            this.readBufferInt = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.ReadBufferIntNodeGen.create(this));
            this.writeBufferInt = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.WriteBufferIntNodeGen.create(this));
            this.readBufferLong = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.ReadBufferLongNodeGen.create(this));
            this.writeBufferLong = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.WriteBufferLongNodeGen.create(this));
            this.readBufferFloat = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.ReadBufferFloatNodeGen.create(this));
            this.writeBufferFloat = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.WriteBufferFloatNodeGen.create(this));
            this.readBufferDouble = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.ReadBufferDoubleNodeGen.create(this));
            this.writeBufferDouble = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.WriteBufferDoubleNodeGen.create(this));
            this.hasMember = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.HasMemberNodeGen.create(this));
            this.getMember = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetMemberNodeGen.create(this));
            this.putMember = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.PutMemberNodeGen.create(this));
            this.removeMember = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.RemoveMemberNodeGen.create(this));
            this.isNull = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsNullNodeGen.create(this));
            this.execute = PolyglotValue.createTarget(new ExecuteNode(this));
            this.executeNoArgs = PolyglotValue.createTarget(new ExecuteNoArgsNode(this));
            this.executeVoid = PolyglotValue.createTarget(new ExecuteVoidNode(this));
            this.executeVoidNoArgs = PolyglotValue.createTarget(new ExecuteVoidNoArgsNode(this));
            this.newInstance = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.NewInstanceNodeGen.create(this));
            this.canInstantiate = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.CanInstantiateNodeGen.create(this));
            this.canExecute = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.CanExecuteNodeGen.create(this));
            this.canInvoke = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.CanInvokeNodeGen.create(this));
            this.invoke = PolyglotValue.createTarget(new InvokeNode(this));
            this.invokeNoArgs = PolyglotValue.createTarget(new InvokeNoArgsNode(this));
            this.hasMembers = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.HasMembersNodeGen.create(this));
            this.isProxy = PolyglotProxy.isProxyGuestObject(receiverObject);
            this.isHost = HostObject.isInstance(receiverObject);
            this.getMemberKeys = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetMemberKeysNodeGen.create(this));
            this.isDate = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsDateNodeGen.create(this));
            this.asDate = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.AsDateNodeGen.create(this));
            this.isTime = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsTimeNodeGen.create(this));
            this.asTime = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.AsTimeNodeGen.create(this));
            this.isTimeZone = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsTimeZoneNodeGen.create(this));
            this.asTimeZone = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.AsTimeZoneNodeGen.create(this));
            this.asInstant = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.AsInstantNodeGen.create(this));
            this.isDuration = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsDurationNodeGen.create(this));
            this.asDuration = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.AsDurationNodeGen.create(this));
            this.isException = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsExceptionNodeGen.create(this));
            this.throwException = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.ThrowExceptionNodeGen.create(this));
            this.isMetaObject = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsMetaObjectNodeGen.create(this));
            this.isMetaInstance = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsMetaInstanceNodeGen.create(this));
            this.getMetaQualifiedName = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetMetaQualifiedNameNodeGen.create(this));
            this.getMetaSimpleName = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetMetaSimpleNameNodeGen.create(this));
            this.hasIterator = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.HasIteratorNodeGen.create(this));
            this.getIterator = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetIteratorNodeGen.create(this));
            this.isIterator = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsIteratorNodeGen.create(this));
            this.hasIteratorNextElement = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.HasIteratorNextElementNodeGen.create(this));
            this.getIteratorNextElement = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetIteratorNextElementNodeGen.create(this));
            this.hasHashEntries = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.HasHashEntriesNodeGen.create(this));
            this.getHashSize = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetHashSizeNodeGen.create(this));
            this.hasHashEntry = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.HasHashEntryNodeGen.create(this));
            this.getHashValue = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetHashValueNodeGen.create(this));
            this.getHashValueOrDefault = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetHashValueOrDefaultNodeGen.create(this));
            this.putHashEntry = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.PutHashEntryNodeGen.create(this));
            this.removeHashEntry = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.RemoveHashEntryNodeGen.create(this));
            this.getHashEntriesIterator = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetHashEntriesIteratorNodeGen.create(this));
            this.getHashKeysIterator = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetHashKeysIteratorNodeGen.create(this));
            this.getHashValuesIterator = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetHashValuesIteratorNodeGen.create(this));
        }

        static abstract class GetHashValuesIteratorNode
        extends InteropNode {
            GetHashValuesIteratorNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getHashValuesIterator";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported) {
                try {
                    return toHost.execute(context, hashes.getHashValuesIterator(receiver));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.getHashEntriesIteratorUnsupported(context, receiver);
                }
            }
        }

        static abstract class GetHashKeysIteratorNode
        extends InteropNode {
            GetHashKeysIteratorNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getHashKeysIterator";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported) {
                try {
                    return toHost.execute(context, hashes.getHashKeysIterator(receiver));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.getHashEntriesIteratorUnsupported(context, receiver);
                }
            }
        }

        static abstract class GetHashEntriesIteratorNode
        extends InteropNode {
            GetHashEntriesIteratorNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getHashEntriesIterator";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported) {
                try {
                    return toHost.execute(context, hashes.getHashEntriesIterator(receiver));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.getHashEntriesIteratorUnsupported(context, receiver);
                }
            }
        }

        static abstract class RemoveHashEntryNode
        extends InteropNode {
            protected RemoveHashEntryNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object.class};
            }

            @Override
            protected String getOperationName() {
                return "removeHashEntry";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached PolyglotLanguageContext.ToGuestValueNode toGuestKey, @Cached BranchProfile unsupported, @Cached BranchProfile invalidKey) {
                Boolean result;
                Object hostKey = args[2];
                Object key = toGuestKey.execute(context, hostKey);
                try {
                    hashes.removeHashEntry(receiver, key);
                    result = Boolean.TRUE;
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (!hashes.hasHashEntries(receiver) || hashes.isHashEntryExisting(receiver, key)) {
                        throw PolyglotValue.removeHashEntryUnsupported(context, receiver, key);
                    }
                    result = Boolean.FALSE;
                }
                catch (UnknownKeyException e) {
                    invalidKey.enter();
                    result = Boolean.FALSE;
                }
                return result;
            }
        }

        static abstract class PutHashEntryNode
        extends InteropNode {
            protected PutHashEntryNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object.class, Object.class};
            }

            @Override
            protected String getOperationName() {
                return "putHashEntry";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached PolyglotLanguageContext.ToGuestValueNode toGuestKey, @Cached PolyglotLanguageContext.ToGuestValueNode toGuestValue, @Cached BranchProfile unsupported, @Cached BranchProfile invalidKey, @Cached BranchProfile invalidValue) {
                Object hostKey = args[2];
                Object hostValue = args[3];
                Object key = toGuestKey.execute(context, hostKey);
                Object value = toGuestValue.execute(context, hostValue);
                try {
                    hashes.writeHashEntry(receiver, key, value);
                }
                catch (UnknownKeyException | UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.putHashEntryUnsupported(context, receiver, key, value);
                }
                catch (UnsupportedTypeException e) {
                    invalidValue.enter();
                    throw PolyglotValue.invalidHashValue(context, receiver, key, value);
                }
                return null;
            }
        }

        static abstract class GetHashValueOrDefaultNode
        extends InteropNode {
            protected GetHashValueOrDefaultNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object.class, Object.class};
            }

            @Override
            protected String getOperationName() {
                return "getHashValueOrDefault";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached PolyglotLanguageContext.ToGuestValueNode toGuestKey, @Cached PolyglotLanguageContext.ToGuestValueNode toGuestDefaultValue, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile invalidKey) {
                Object hostKey = args[2];
                Object hostDefaultValue = args[3];
                Object key = toGuestKey.execute(context, hostKey);
                Object defaultValue = toGuestDefaultValue.execute(context, hostDefaultValue);
                try {
                    return toHost.execute(context, hashes.readHashValueOrDefault(receiver, key, hostDefaultValue));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.getHashValueUnsupported(context, receiver, key);
                }
            }
        }

        static abstract class GetHashValueNode
        extends InteropNode {
            protected GetHashValueNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object.class};
            }

            @Override
            protected String getOperationName() {
                return "getHashValue";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached PolyglotLanguageContext.ToGuestValueNode toGuestKey, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile invalidKey) {
                Object hostKey = args[2];
                Object key = toGuestKey.execute(context, hostKey);
                try {
                    return toHost.execute(context, hashes.readHashValue(receiver, key));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.getHashValueUnsupported(context, receiver, key);
                }
                catch (UnknownKeyException e) {
                    invalidKey.enter();
                    if (hashes.isHashEntryExisting(receiver, key)) {
                        throw PolyglotValue.getHashValueUnsupported(context, receiver, key);
                    }
                    return null;
                }
            }
        }

        static abstract class HasHashEntryNode
        extends InteropNode {
            protected HasHashEntryNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object.class};
            }

            @Override
            protected String getOperationName() {
                return "hasHashEntry";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached PolyglotLanguageContext.ToGuestValueNode toGuestKey) {
                Object hostKey = args[2];
                Object key = toGuestKey.execute(context, hostKey);
                return hashes.isHashEntryExisting(receiver, key);
            }
        }

        static abstract class GetHashSizeNode
        extends InteropNode {
            protected GetHashSizeNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getHashSize";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached BranchProfile unsupported) {
                try {
                    return hashes.getHashSize(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.getHashSizeUnsupported(context, receiver);
                }
            }
        }

        static abstract class HasHashEntriesNode
        extends InteropNode {
            protected HasHashEntriesNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasHashEntries";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary hashes) {
                return hashes.hasHashEntries(receiver);
            }
        }

        static abstract class GetIteratorNextElementNode
        extends InteropNode {
            protected GetIteratorNextElementNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getIteratorNextElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary iterators, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile stop) {
                try {
                    return toHost.execute(context, iterators.getIteratorNextElement(receiver));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.nonReadableIteratorElement();
                }
                catch (StopIterationException e) {
                    stop.enter();
                    throw PolyglotValue.stopIteration(context, receiver);
                }
            }
        }

        static abstract class HasIteratorNextElementNode
        extends InteropNode {
            protected HasIteratorNextElementNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasIteratorNextElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary iterators, @Cached BranchProfile unsupported) {
                try {
                    return iterators.hasIteratorNextElement(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    return PolyglotValue.hasIteratorNextElementUnsupported(context, receiver);
                }
            }
        }

        static abstract class IsIteratorNode
        extends InteropNode {
            protected IsIteratorNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isIterator";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary iterators) {
                return iterators.isIterator(receiver);
            }
        }

        static abstract class GetIteratorNode
        extends InteropNode {
            protected GetIteratorNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getIterator";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary iterators, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported) {
                try {
                    return toHost.execute(context, iterators.getIterator(receiver));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    return PolyglotValue.getIteratorUnsupported(context, receiver);
                }
            }
        }

        static abstract class HasIteratorNode
        extends InteropNode {
            protected HasIteratorNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasIterator";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary iterators) {
                return iterators.hasIterator(receiver);
            }
        }

        static abstract class IsMetaInstanceNode
        extends InteropNode {
            protected IsMetaInstanceNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, null};
            }

            @Override
            protected String getOperationName() {
                return "isMetaInstance";
            }

            @Specialization(limit="CACHE_LIMIT")
            static boolean doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached PolyglotLanguageContext.ToGuestValueNode toGuest, @Cached BranchProfile unsupported) {
                try {
                    return objects.isMetaInstance(receiver, toGuest.execute(context, args[2]));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.unsupported(context, receiver, "throwException()", "isException()");
                }
            }
        }

        static abstract class GetMetaSimpleNameNode
        extends InteropNode {
            protected GetMetaSimpleNameNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getMetaSimpleName";
            }

            @Specialization(limit="CACHE_LIMIT")
            static String doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @CachedLibrary(limit="1") InteropLibrary toString, @Cached BranchProfile unsupported) {
                try {
                    return toString.asString(objects.getMetaSimpleName(receiver));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.unsupported(context, receiver, "throwException()", "isException()");
                }
            }
        }

        static abstract class GetMetaQualifiedNameNode
        extends InteropNode {
            protected GetMetaQualifiedNameNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getMetaQualifiedName";
            }

            @Specialization(limit="CACHE_LIMIT")
            static String doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @CachedLibrary(limit="1") InteropLibrary toString, @Cached BranchProfile unsupported) {
                try {
                    return toString.asString(objects.getMetaQualifiedName(receiver));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.unsupported(context, receiver, "throwException()", "isException()");
                }
            }
        }

        static abstract class IsMetaObjectNode
        extends InteropNode {
            protected IsMetaObjectNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isMetaObject";
            }

            @Specialization(limit="CACHE_LIMIT")
            static boolean doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isMetaObject(receiver);
            }
        }

        static abstract class ThrowExceptionNode
        extends InteropNode {
            protected ThrowExceptionNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "throwException";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported) {
                try {
                    throw objects.throwException(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.unsupported(context, receiver, "throwException()", "isException()");
                }
            }
        }

        static abstract class IsExceptionNode
        extends InteropNode {
            protected IsExceptionNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isException";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isException(receiver);
            }
        }

        private static class InvokeNoArgsNode
        extends AbstractInvokeNode {
            protected InvokeNoArgsNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class};
            }

            @Override
            protected String getOperationName() {
                return "invoke";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                String key = (String)args[2];
                return this.executeShared(context, receiver, key, ExecuteVoidNoArgsNode.NO_ARGS);
            }
        }

        private static class InvokeNode
        extends AbstractInvokeNode {
            private final PolyglotLanguageContext.ToGuestValuesNode toGuestValues = PolyglotLanguageContext.ToGuestValuesNode.create();

            protected InvokeNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class, Object[].class};
            }

            @Override
            protected String getOperationName() {
                return "invoke";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                String key = (String)args[2];
                Object[] guestArguments = this.toGuestValues.apply(context, (Object[])args[3]);
                return this.executeShared(context, receiver, key, guestArguments);
            }
        }

        private static abstract class AbstractInvokeNode
        extends InteropNode {
            @Node.Child
            private InteropLibrary objects = InteropLibrary.getFactory().createDispatched(5);
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;
            private final BranchProfile invalidArgument = BranchProfile.create();
            private final BranchProfile arity = BranchProfile.create();
            private final BranchProfile unsupported = BranchProfile.create();
            private final BranchProfile unknownIdentifier = BranchProfile.create();

            protected AbstractInvokeNode(InteropCodeCache interop) {
                super(interop);
                this.toHostValue = PolyglotLanguageContext.ToHostValueNode.create(interop.languageInstance.language.getImpl());
            }

            protected final Object executeShared(PolyglotLanguageContext context, Object receiver, String key, Object[] guestArguments) {
                try {
                    return this.toHostValue.execute(context, this.objects.invokeMember(receiver, key, guestArguments));
                }
                catch (UnsupportedMessageException e) {
                    this.unsupported.enter();
                    throw PolyglotValue.invokeUnsupported(context, receiver, key);
                }
                catch (UnknownIdentifierException e) {
                    this.unknownIdentifier.enter();
                    throw PolyglotValue.nonReadableMemberKey(context, receiver, key);
                }
                catch (UnsupportedTypeException e) {
                    this.invalidArgument.enter();
                    throw PolyglotValue.invalidInvokeArgumentType(context, receiver, key, e);
                }
                catch (ArityException e) {
                    this.arity.enter();
                    throw PolyglotValue.invalidInvokeArity(context, receiver, key, guestArguments, e.getExpectedArity(), e.getActualArity());
                }
            }
        }

        static abstract class NewInstanceNode
        extends InteropNode {
            private final PolyglotLanguageContext.ToGuestValuesNode toGuestValues = PolyglotLanguageContext.ToGuestValuesNode.create();
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;

            protected NewInstanceNode(InteropCodeCache interop) {
                super(interop);
                this.toHostValue = PolyglotLanguageContext.ToHostValueNode.create(interop.languageInstance.language.getImpl());
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object[].class};
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary instantiables, @Cached PolyglotLanguageContext.ToGuestValuesNode toGuestValues, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHostValue, @Cached BranchProfile arity, @Cached BranchProfile invalidArgument, @Cached BranchProfile unsupported) {
                Object[] instantiateArguments = toGuestValues.apply(context, (Object[])args[2]);
                try {
                    return toHostValue.execute(context, instantiables.instantiate(receiver, instantiateArguments));
                }
                catch (UnsupportedTypeException e) {
                    invalidArgument.enter();
                    throw PolyglotValue.invalidInstantiateArgumentType(context, receiver, instantiateArguments);
                }
                catch (ArityException e) {
                    arity.enter();
                    throw PolyglotValue.invalidInstantiateArity(context, receiver, instantiateArguments, e.getExpectedArity(), e.getActualArity());
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    return PolyglotValue.newInstanceUnsupported(context, receiver);
                }
            }

            @Override
            protected String getOperationName() {
                return "newInstance";
            }
        }

        private static class ExecuteNoArgsNode
        extends AbstractExecuteNode {
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;

            protected ExecuteNoArgsNode(InteropCodeCache interop) {
                super(interop);
                this.toHostValue = PolyglotLanguageContext.ToHostValueNode.create(interop.languageInstance.language.getImpl());
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                return this.toHostValue.execute(context, this.executeShared(context, receiver, ExecuteVoidNoArgsNode.NO_ARGS));
            }

            @Override
            protected String getOperationName() {
                return "execute";
            }
        }

        private static class ExecuteNode
        extends AbstractExecuteNode {
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;

            protected ExecuteNode(InteropCodeCache interop) {
                super(interop);
                this.toHostValue = PolyglotLanguageContext.ToHostValueNode.create(interop.languageInstance.language.getImpl());
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object[].class};
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                return this.toHostValue.execute(context, this.executeShared(context, receiver, (Object[])args[2]));
            }

            @Override
            protected String getOperationName() {
                return "execute";
            }
        }

        private static class ExecuteVoidNoArgsNode
        extends AbstractExecuteNode {
            private static final Object[] NO_ARGS = new Object[0];

            protected ExecuteVoidNoArgsNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                this.executeShared(context, receiver, NO_ARGS);
                return null;
            }

            @Override
            protected String getOperationName() {
                return "executeVoid";
            }
        }

        private static class ExecuteVoidNode
        extends AbstractExecuteNode {
            protected ExecuteVoidNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object[].class};
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                this.executeShared(context, receiver, (Object[])args[2]);
                return null;
            }

            @Override
            protected String getOperationName() {
                return "executeVoid";
            }
        }

        private static abstract class AbstractExecuteNode
        extends InteropNode {
            @Node.Child
            private InteropLibrary executables = InteropLibrary.getFactory().createDispatched(5);
            private final PolyglotLanguageContext.ToGuestValuesNode toGuestValues = PolyglotLanguageContext.ToGuestValuesNode.create();
            private final BranchProfile invalidArgument = BranchProfile.create();
            private final BranchProfile arity = BranchProfile.create();
            private final BranchProfile unsupported = BranchProfile.create();

            protected AbstractExecuteNode(InteropCodeCache interop) {
                super(interop);
            }

            protected final Object executeShared(PolyglotLanguageContext context, Object receiver, Object[] args) {
                Object[] guestArguments = this.toGuestValues.apply(context, args);
                try {
                    return this.executables.execute(receiver, guestArguments);
                }
                catch (UnsupportedTypeException e) {
                    this.invalidArgument.enter();
                    throw PolyglotValue.invalidExecuteArgumentType(context, receiver, e);
                }
                catch (ArityException e) {
                    this.arity.enter();
                    throw PolyglotValue.invalidExecuteArity(context, receiver, guestArguments, e.getExpectedArity(), e.getActualArity());
                }
                catch (UnsupportedMessageException e) {
                    this.unsupported.enter();
                    throw PolyglotValue.executeUnsupported(context, receiver);
                }
            }
        }

        static abstract class CanInstantiateNode
        extends InteropNode {
            protected CanInstantiateNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "canInstantiate";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary instantiables) {
                return instantiables.isInstantiable(receiver);
            }
        }

        static abstract class CanExecuteNode
        extends InteropNode {
            protected CanExecuteNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "canExecute";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary executables) {
                return executables.isExecutable(receiver);
            }
        }

        static abstract class CanInvokeNode
        extends AbstractMemberInfoNode {
            protected CanInvokeNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "canInvoke";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                String key = (String)args[2];
                return objects.isMemberInvocable(receiver, key);
            }
        }

        static abstract class HasMemberNode
        extends AbstractMemberInfoNode {
            protected HasMemberNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "hasMember";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                String key = (String)args[2];
                return objects.isMemberExisting(receiver, key);
            }
        }

        private static abstract class AbstractMemberInfoNode
        extends InteropNode {
            protected AbstractMemberInfoNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected final Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class};
            }
        }

        static abstract class HasMembersNode
        extends InteropNode {
            protected HasMembersNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasMembers";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.hasMembers(receiver);
            }
        }

        static abstract class IsNullNode
        extends InteropNode {
            protected IsNullNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isNull";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary values) {
                return values.isNull(receiver);
            }
        }

        static abstract class RemoveMemberNode
        extends InteropNode {
            protected RemoveMemberNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "removeMember";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class};
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported, @Cached BranchProfile unknown) {
                Boolean value;
                String key = (String)args[2];
                try {
                    assert (key != null) : "should be handled already";
                    objects.removeMember(receiver, key);
                    value = Boolean.TRUE;
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (!objects.hasMembers(receiver)) {
                        throw PolyglotValue.removeMemberUnsupported(context, receiver);
                    }
                    if (objects.isMemberExisting(receiver, key)) {
                        throw PolyglotValue.nonRemovableMemberKey(context, receiver, key);
                    }
                    value = Boolean.FALSE;
                }
                catch (UnknownIdentifierException e) {
                    unknown.enter();
                    if (objects.isMemberExisting(receiver, key)) {
                        throw PolyglotValue.nonRemovableMemberKey(context, receiver, key);
                    }
                    value = Boolean.FALSE;
                }
                return value;
            }
        }

        static abstract class PutMemberNode
        extends InteropNode {
            protected PutMemberNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "putMember";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class, null};
            }

            @Specialization
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(limit="CACHE_LIMIT") InteropLibrary objects, @Cached PolyglotLanguageContext.ToGuestValueNode toGuestValue, @Cached BranchProfile unsupported, @Cached BranchProfile invalidValue, @Cached BranchProfile unknown) {
                String key = (String)args[2];
                Object originalValue = args[3];
                Object value = toGuestValue.execute(context, originalValue);
                assert (key != null);
                try {
                    objects.writeMember(receiver, key, value);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.putMemberUnsupported(context, receiver);
                }
                catch (UnknownIdentifierException e) {
                    unknown.enter();
                    throw PolyglotValue.nonWritableMemberKey(context, receiver, key);
                }
                catch (UnsupportedTypeException e) {
                    invalidValue.enter();
                    throw PolyglotValue.invalidMemberValue(context, receiver, key, value);
                }
                return null;
            }
        }

        static abstract class GetMemberNode
        extends InteropNode {
            protected GetMemberNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class};
            }

            @Override
            protected String getOperationName() {
                return "getMember";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile unknown) {
                Value value;
                String key = (String)args[2];
                try {
                    assert (key != null) : "should be handled already";
                    value = toHost.execute(context, objects.readMember(receiver, key));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (objects.hasMembers(receiver)) {
                        value = null;
                    }
                    return PolyglotValue.getMemberUnsupported(context, receiver, key);
                }
                catch (UnknownIdentifierException e) {
                    unknown.enter();
                    value = null;
                }
                return value;
            }
        }

        static abstract class WriteBufferDoubleNode
        extends InteropNode {
            protected WriteBufferDoubleNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class, Double.class};
            }

            @Override
            protected String getOperationName() {
                return "writeBufferDouble";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached BranchProfile unsupported, @Cached BranchProfile invalidIndex, @Cached BranchProfile invalidValue) {
                ByteOrder order = (ByteOrder)args[2];
                long byteOffset = (Long)args[3];
                double value = (Double)args[4];
                try {
                    buffers.writeBufferDouble(receiver, order, byteOffset, value);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (buffers.hasBufferElements(receiver)) {
                        throw PolyglotValue.unsupported(context, receiver, "writeBufferDouble()", "isBufferWritable()");
                    }
                    throw PolyglotValue.writeBufferDoubleUnsupported(context, receiver);
                }
                catch (InvalidBufferOffsetException e) {
                    invalidIndex.enter();
                    throw PolyglotValue.invalidBufferIndex(context, receiver, e.getByteOffset(), e.getLength());
                }
                return null;
            }
        }

        static abstract class ReadBufferDoubleNode
        extends InteropNode {
            protected ReadBufferDoubleNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "readBufferDouble";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile unknown) {
                ByteOrder order = (ByteOrder)args[2];
                long byteOffset = (Long)args[3];
                try {
                    return buffers.readBufferDouble(receiver, order, byteOffset);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.readBufferDoubleUnsupported(context, receiver);
                }
                catch (InvalidBufferOffsetException e) {
                    unknown.enter();
                    throw PolyglotValue.invalidBufferIndex(context, receiver, e.getByteOffset(), e.getLength());
                }
            }
        }

        static abstract class WriteBufferFloatNode
        extends InteropNode {
            protected WriteBufferFloatNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class, Float.class};
            }

            @Override
            protected String getOperationName() {
                return "writeBufferFloat";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached BranchProfile unsupported, @Cached BranchProfile invalidIndex, @Cached BranchProfile invalidValue) {
                ByteOrder order = (ByteOrder)args[2];
                long byteOffset = (Long)args[3];
                float value = ((Float)args[4]).floatValue();
                try {
                    buffers.writeBufferFloat(receiver, order, byteOffset, value);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (buffers.hasBufferElements(receiver)) {
                        throw PolyglotValue.unsupported(context, receiver, "writeBufferFloat()", "isBufferWritable()");
                    }
                    throw PolyglotValue.writeBufferFloatUnsupported(context, receiver);
                }
                catch (InvalidBufferOffsetException e) {
                    invalidIndex.enter();
                    throw PolyglotValue.invalidBufferIndex(context, receiver, e.getByteOffset(), e.getLength());
                }
                return null;
            }
        }

        static abstract class ReadBufferFloatNode
        extends InteropNode {
            protected ReadBufferFloatNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "readBufferFloat";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile unknown) {
                ByteOrder order = (ByteOrder)args[2];
                long byteOffset = (Long)args[3];
                try {
                    return Float.valueOf(buffers.readBufferFloat(receiver, order, byteOffset));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.readBufferFloatUnsupported(context, receiver);
                }
                catch (InvalidBufferOffsetException e) {
                    unknown.enter();
                    throw PolyglotValue.invalidBufferIndex(context, receiver, e.getByteOffset(), e.getLength());
                }
            }
        }

        static abstract class WriteBufferLongNode
        extends InteropNode {
            protected WriteBufferLongNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "writeBufferLong";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached BranchProfile unsupported, @Cached BranchProfile invalidIndex, @Cached BranchProfile invalidValue) {
                ByteOrder order = (ByteOrder)args[2];
                long byteOffset = (Long)args[3];
                long value = (Long)args[4];
                try {
                    buffers.writeBufferLong(receiver, order, byteOffset, value);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (buffers.hasBufferElements(receiver)) {
                        throw PolyglotValue.unsupported(context, receiver, "writeBufferLong()", "isBufferWritable()");
                    }
                    throw PolyglotValue.writeBufferLongUnsupported(context, receiver);
                }
                catch (InvalidBufferOffsetException e) {
                    invalidIndex.enter();
                    throw PolyglotValue.invalidBufferIndex(context, receiver, e.getByteOffset(), e.getLength());
                }
                return null;
            }
        }

        static abstract class ReadBufferLongNode
        extends InteropNode {
            protected ReadBufferLongNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "readBufferLong";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile unknown) {
                ByteOrder order = (ByteOrder)args[2];
                long byteOffset = (Long)args[3];
                try {
                    return buffers.readBufferLong(receiver, order, byteOffset);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.readBufferLongUnsupported(context, receiver);
                }
                catch (InvalidBufferOffsetException e) {
                    unknown.enter();
                    throw PolyglotValue.invalidBufferIndex(context, receiver, e.getByteOffset(), e.getLength());
                }
            }
        }

        static abstract class WriteBufferIntNode
        extends InteropNode {
            protected WriteBufferIntNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class, Integer.class};
            }

            @Override
            protected String getOperationName() {
                return "writeBufferInt";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached BranchProfile unsupported, @Cached BranchProfile invalidIndex, @Cached BranchProfile invalidValue) {
                ByteOrder order = (ByteOrder)args[2];
                long byteOffset = (Long)args[3];
                int value = (Integer)args[4];
                try {
                    buffers.writeBufferInt(receiver, order, byteOffset, value);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (buffers.hasBufferElements(receiver)) {
                        throw PolyglotValue.unsupported(context, receiver, "writeBufferInt()", "isBufferWritable()");
                    }
                    throw PolyglotValue.writeBufferIntUnsupported(context, receiver);
                }
                catch (InvalidBufferOffsetException e) {
                    invalidIndex.enter();
                    throw PolyglotValue.invalidBufferIndex(context, receiver, e.getByteOffset(), e.getLength());
                }
                return null;
            }
        }

        static abstract class ReadBufferIntNode
        extends InteropNode {
            protected ReadBufferIntNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "readBufferInt";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile unknown) {
                ByteOrder order = (ByteOrder)args[2];
                long byteOffset = (Long)args[3];
                try {
                    return buffers.readBufferInt(receiver, order, byteOffset);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.readBufferIntUnsupported(context, receiver);
                }
                catch (InvalidBufferOffsetException e) {
                    unknown.enter();
                    throw PolyglotValue.invalidBufferIndex(context, receiver, e.getByteOffset(), e.getLength());
                }
            }
        }

        static abstract class WriteBufferShortNode
        extends InteropNode {
            protected WriteBufferShortNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class, Short.class};
            }

            @Override
            protected String getOperationName() {
                return "writeBufferShort";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached BranchProfile unsupported, @Cached BranchProfile invalidIndex, @Cached BranchProfile invalidValue) {
                ByteOrder order = (ByteOrder)args[2];
                long byteOffset = (Long)args[3];
                short value = (Short)args[4];
                try {
                    buffers.writeBufferShort(receiver, order, byteOffset, value);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (buffers.hasBufferElements(receiver)) {
                        throw PolyglotValue.unsupported(context, receiver, "writeBufferShort()", "isBufferWritable()");
                    }
                    throw PolyglotValue.writeBufferShortUnsupported(context, receiver);
                }
                catch (InvalidBufferOffsetException e) {
                    invalidIndex.enter();
                    throw PolyglotValue.invalidBufferIndex(context, receiver, e.getByteOffset(), e.getLength());
                }
                return null;
            }
        }

        static abstract class ReadBufferShortNode
        extends InteropNode {
            protected ReadBufferShortNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "readBufferShort";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile unknown) {
                ByteOrder order = (ByteOrder)args[2];
                long byteOffset = (Long)args[3];
                try {
                    return buffers.readBufferShort(receiver, order, byteOffset);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.readBufferShortUnsupported(context, receiver);
                }
                catch (InvalidBufferOffsetException e) {
                    unknown.enter();
                    throw PolyglotValue.invalidBufferIndex(context, receiver, e.getByteOffset(), e.getLength());
                }
            }
        }

        static abstract class WriteBufferByteNode
        extends InteropNode {
            protected WriteBufferByteNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class, Byte.class};
            }

            @Override
            protected String getOperationName() {
                return "writeBufferByte";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached BranchProfile unsupported, @Cached BranchProfile invalidIndex, @Cached BranchProfile invalidValue) {
                long byteOffset = (Long)args[2];
                byte value = (Byte)args[3];
                try {
                    buffers.writeBufferByte(receiver, byteOffset, value);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (buffers.hasBufferElements(receiver)) {
                        throw PolyglotValue.unsupported(context, receiver, "writeBufferByte()", "isBufferWritable()");
                    }
                    throw PolyglotValue.writeBufferByteUnsupported(context, receiver);
                }
                catch (InvalidBufferOffsetException e) {
                    invalidIndex.enter();
                    throw PolyglotValue.invalidBufferIndex(context, receiver, e.getByteOffset(), e.getLength());
                }
                return null;
            }
        }

        static abstract class ReadBufferByteNode
        extends InteropNode {
            protected ReadBufferByteNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "readBufferByte";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile unknown) {
                long byteOffset = (Long)args[2];
                try {
                    return buffers.readBufferByte(receiver, byteOffset);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.readBufferByteUnsupported(context, receiver);
                }
                catch (InvalidBufferOffsetException e) {
                    unknown.enter();
                    throw PolyglotValue.invalidBufferIndex(context, receiver, e.getByteOffset(), e.getLength());
                }
            }
        }

        static abstract class GetBufferSizeNode
        extends InteropNode {
            protected GetBufferSizeNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getBufferSize";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached BranchProfile unsupported) {
                try {
                    return buffers.getBufferSize(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.getBufferSizeUnsupported(context, receiver);
                }
            }
        }

        static abstract class IsBufferWritableNode
        extends InteropNode {
            protected IsBufferWritableNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isBufferWritable";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached BranchProfile unsupported) {
                try {
                    return buffers.isBufferWritable(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.getBufferSizeUnsupported(context, receiver);
                }
            }
        }

        static abstract class HasBufferElementsNode
        extends InteropNode {
            protected HasBufferElementsNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasBufferElements";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary buffers) {
                return buffers.hasBufferElements(receiver);
            }
        }

        static abstract class GetArraySizeNode
        extends InteropNode {
            protected GetArraySizeNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getArraySize";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary arrays, @Cached BranchProfile unsupported) {
                try {
                    return arrays.getArraySize(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    return PolyglotValue.getArraySizeUnsupported(context, receiver);
                }
            }
        }

        static abstract class RemoveArrayElementNode
        extends InteropNode {
            protected RemoveArrayElementNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "removeArrayElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary arrays, @Cached BranchProfile unsupported, @Cached BranchProfile invalidIndex) {
                Boolean value;
                long index = (Long)args[2];
                try {
                    arrays.removeArrayElement(receiver, index);
                    value = Boolean.TRUE;
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.removeArrayElementUnsupported(context, receiver);
                }
                catch (InvalidArrayIndexException e) {
                    invalidIndex.enter();
                    throw PolyglotValue.invalidArrayIndex(context, receiver, index);
                }
                return value;
            }
        }

        static abstract class SetArrayElementNode
        extends InteropNode {
            protected SetArrayElementNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class, null};
            }

            @Override
            protected String getOperationName() {
                return "setArrayElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary arrays, @Cached PolyglotLanguageContext.ToGuestValueNode toGuestValue, @Cached BranchProfile unsupported, @Cached BranchProfile invalidIndex, @Cached BranchProfile invalidValue) {
                long index = (Long)args[2];
                Object value = toGuestValue.execute(context, args[3]);
                try {
                    arrays.writeArrayElement(receiver, index, value);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    PolyglotValue.setArrayElementUnsupported(context, receiver);
                }
                catch (UnsupportedTypeException e) {
                    invalidValue.enter();
                    throw PolyglotValue.invalidArrayValue(context, receiver, index, value);
                }
                catch (InvalidArrayIndexException e) {
                    invalidIndex.enter();
                    throw PolyglotValue.invalidArrayIndex(context, receiver, index);
                }
                return null;
            }
        }

        static abstract class GetArrayElementNode
        extends InteropNode {
            protected GetArrayElementNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "getArrayElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary arrays, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile unknown) {
                long index = (Long)args[2];
                try {
                    return toHost.execute(context, arrays.readArrayElement(receiver, index));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    return PolyglotValue.getArrayElementUnsupported(context, receiver);
                }
                catch (InvalidArrayIndexException e) {
                    unknown.enter();
                    throw PolyglotValue.invalidArrayIndex(context, receiver, index);
                }
            }
        }

        static abstract class GetMemberKeysNode
        extends InteropNode {
            protected GetMemberKeysNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getMemberKeys";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported) {
                try {
                    return toHost.execute(context, objects.getMembers(receiver));
                }
                catch (UnsupportedMessageException e) {
                    return null;
                }
            }
        }

        static abstract class HasArrayElementsNode
        extends InteropNode {
            protected HasArrayElementsNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasArrayElements";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary arrays) {
                return arrays.hasArrayElements(receiver);
            }
        }

        static abstract class AsNativePointerNode
        extends InteropNode {
            protected AsNativePointerNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asNativePointer";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary natives, @Cached BranchProfile unsupported) {
                try {
                    return natives.asPointer(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.cannotConvert(context, receiver, Long.TYPE, "asNativePointer()", "isNativeObject()", "Value cannot be converted to a native pointer.");
                }
            }
        }

        static abstract class IsNativePointerNode
        extends InteropNode {
            protected IsNativePointerNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isNativePointer";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary natives) {
                return natives.isPointer(receiver);
            }
        }

        private static class AsTypeLiteralNode
        extends InteropNode {
            @Node.Child
            ToHostNode toHost = ToHostNodeGen.create();

            protected AsTypeLiteralNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, TypeLiteral.class};
            }

            @Override
            protected String getOperationName() {
                return "as";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                TypeLiteral typeLiteral = (TypeLiteral)args[2];
                return this.toHost.execute(receiver, typeLiteral.getRawType(), typeLiteral.getType(), context, true);
            }
        }

        private static class AsClassLiteralNode
        extends InteropNode {
            @Node.Child
            ToHostNode toHost = ToHostNodeGen.create();

            protected AsClassLiteralNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Class.class};
            }

            @Override
            protected String getOperationName() {
                return "as";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                return this.toHost.execute(receiver, (Class)args[2], null, context, true);
            }
        }

        static abstract class AsInstantNode
        extends InteropNode {
            protected AsInstantNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getInstant";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported) {
                try {
                    return objects.asInstant(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValue.cannotConvert(context, receiver, null, "asInstant()", "hasInstant()", "Value does not contain instant information.");
                }
            }
        }

        static abstract class AsDurationNode
        extends InteropNode {
            protected AsDurationNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asDuration";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported) {
                try {
                    return objects.asDuration(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValue.cannotConvert(context, receiver, null, "asDuration()", "isDuration()", "Value does not contain duration information.");
                }
            }
        }

        static abstract class IsDurationNode
        extends InteropNode {
            protected IsDurationNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isDuration";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isDuration(receiver);
            }
        }

        static abstract class AsTimeZoneNode
        extends InteropNode {
            protected AsTimeZoneNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asTimeZone";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported) {
                try {
                    return objects.asTimeZone(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValue.cannotConvert(context, receiver, null, "asTimeZone()", "isTimeZone()", "Value does not contain time-zone information.");
                }
            }
        }

        static abstract class IsTimeZoneNode
        extends InteropNode {
            protected IsTimeZoneNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isTimeZone";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isTimeZone(receiver);
            }
        }

        static abstract class AsTimeNode
        extends InteropNode {
            protected AsTimeNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asTime";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported) {
                try {
                    return objects.asTime(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValue.cannotConvert(context, receiver, null, "asTime()", "isTime()", "Value does not contain time information.");
                }
            }
        }

        static abstract class IsTimeNode
        extends InteropNode {
            protected IsTimeNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isTime";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isTime(receiver);
            }
        }

        static abstract class AsDateNode
        extends InteropNode {
            protected AsDateNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asDate";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported) {
                try {
                    return objects.asDate(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValue.cannotConvert(context, receiver, null, "asDate()", "isDate()", "Value does not contain date information.");
                }
            }
        }

        static abstract class IsDateNode
        extends InteropNode {
            protected IsDateNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isDate";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isDate(receiver);
            }
        }
    }
}

